﻿//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Core
//===============================================================================
// Copyright © Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

namespace Microsoft.Practices.EnterpriseLibrary.Security.Configuration.Design
{
    /// <summary> 
    /// Specifies the color of underline for a segment of rich text. 
    /// </summary> 
    enum UnderlineColor
    {
        /// <summary> 
        /// No specific underline color specified. 
        /// </summary> 
        None = -1,

        /// <summary> 
        /// Black. 
        /// </summary> 
        Black = 0x00,

        /// <summary> 
        /// Blue. 
        /// </summary> 
        Blue = 0x10,

        /// <summary> 
        /// Cyan. 
        /// </summary> 
        Cyan = 0x20,

        /// <summary> 
        /// LimeGreen. 
        /// </summary> 
        LimeGreen = 0x30,

        /// <summary> 
        /// Magenta. 
        /// </summary> 
        Magenta = 0x40,

        /// <summary> 
        /// Red. 
        /// </summary> 
        Red = 0x50,

        /// <summary> 
        /// Yellow. 
        /// </summary> 
        Yellow = 0x60,

        /// <summary> 
        /// White. 
        /// </summary> 
        White = 0x70,

        /// <summary> 
        /// DarkBlue. 
        /// </summary> 
        DarkBlue = 0x80,

        /// <summary> 
        /// DarkCyan. 
        /// </summary> 
        DarkCyan = 0x90,

        /// <summary> 
        /// Green. 
        /// </summary> 
        Green = 0xA0,

        /// <summary> 
        /// DarkMagenta. 
        /// </summary> 
        DarkMagenta = 0xB0,

        /// <summary> 
        /// Brown. 
        /// </summary> 
        Brown = 0xC0,

        /// <summary> 
        /// OliveGreen. 
        /// </summary> 
        OliveGreen = 0xD0,

        /// <summary> 
        /// DarkGray. 
        /// </summary> 
        DarkGray = 0xE0,

        /// <summary> 
        /// Gray. 
        /// </summary> 
        Gray = 0xF0
    }
}
